/* basicweb.ProxyServer.java
 * $Id, $Date eric Exp $
 * (c) COPYRIGHT MIT and INRIA, 1997.
 * Please first read the full copyright statement in file COPYRIGHT.html
 *
 * Full of Sound and Fury...
 */

/*+
The ProxyServer acts as the server side of a proxy. The client role is filled
by <A HREF=ProxyClient.html>ProxyClient</A> which is kicked of as a request 
method by <A HREF=ProxyRequest.html#ProxyRequest.lookupMethod>ProxyRequest.lookupMethod</A>.
*/
package w3c.model.tools.basicweb;

import java.io.*;
import java.net.Socket;
import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.PEPProxy;
import w3c.model.www.pep.PEPProxyClient;
import w3c.model.www.pep.altlib.Informer;
import w3c.model.www.pep.altlib.ErrorContext;
import w3c.model.www.pep.altlib.HttpErrors;
import w3c.model.www.pep.altlib.HTTPException;
import w3c.model.www.pep.altlib.HttpParserException;

class ProxyServer extends BaseServer
{
    PEPProxyClient pepClient;
    ProxyServer (int port, Informer informer) throws IOException{
    	super(port, informer);
	pepClient = new PEPProxyClient();	// for CopyBodyProxy to talk to servers
	inform("proxy server port: " + port);
	super.serve();
    }

    Request makeRequest (Socket socket, InputStream in, OutputStream out, PEPAgent pepAgent, ErrorContext errorContext) {
	return new ProxyRequest(socket, in, null, pepAgent, errorContext, pepClient);
    }

    void prepPEP () throws HttpParserException, HTTPException {
	pepAgent = new PEPProxy();	// for talking to clients
    }

    void preServe (Request request) {}

    public static void main (String args[]) throws IOException {
	int proxyPort = 8887;
	for (int i = 0 ; i < args.length ; i++) {
	    if ( args[i].equals ("-port") ) {
		try {
		    proxyPort = Integer.parseInt(args[++i]) ;
		} catch (NumberFormatException ex) {
		    System.out.println("invalid port number ["+args[i]+"]");
		    System.exit (1) ;
		}
	    }
	}
	new ProxyServer(proxyPort, new Informer("<Psrver>", ": "));
    }
}
