package w3c.model.tools.basicweb;

import java.io.*;
import java.net.*;
import java.util.*;
import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.altlib.HttpErrors;
import w3c.model.www.pep.altlib.ErrorContext;

class Request extends Message implements HttpErrors
{
    int methodNumber;
    Method requestMethod;
    String httpVersion;

    public final int GET = 0;
    public final int ITZA_PEP = 1;
    public final int PEP_GET = GET | ITZA_PEP;
    public final int PUT = 2;
    public final int PEP_PUT = PUT | ITZA_PEP;
    public final int _METHODS_COUNT = 4;
    final String methods[] = {"GET", "PEP-GET", "PUT", "PEP-PUT"};

    Request (Socket socket, InputStream in, OutputStream out, Method method, URL url, PEPAgent pepAgent, ErrorContext errorContext) {
	super(socket, in, out, url.toString(), pepAgent, errorContext); /* used by Client */
	setMethod(method);
	makeRequestLine(getMethod1(), url, "1.1");
	setHeaderValue(HOST, url.getHost());
    }

    Request (Socket socket, InputStream in, OutputStream out, PEPAgent pepAgent, ErrorContext errorContext) {
	super(socket, in, out, null, pepAgent, errorContext); /* used by Server */
    }

    Method getMethod () {return requestMethod;}

    boolean read () throws IOException {
	if (!super.read())
	    return false;
	if (getHeaderValue(HOST) == null)
	    httpVersion = "1.0";
	return true;
    }

    boolean parseStartLine () {
	int iRequestURI, iHttpVersion;
	int oldError = errorContext.getError();
	if ((iRequestURI = startLine.indexOf(' ')) < 0 || (iHttpVersion = startLine.indexOf(' ', iRequestURI + 1)) < 0) {
	    errorContext.promoteError(REQUEST_BAD);
	    return false;
	}
	methodNumber = arrayFind(methods, startLine.substring(0, iRequestURI));
	URI = startLine.substring(iRequestURI+1, iHttpVersion);
	httpVersion = startLine.substring(iHttpVersion+1);

	if (!httpVersion.startsWith("HTTP/")) {
	    errorContext.promoteError(REQUEST_BAD);
	    return false;
	}
	httpVersion = httpVersion.substring(5);
	requestMethod = lookupMethod(methodNumber);
	return requestMethod == null ? false : ((MethodServer)requestMethod).initialize(this);
    }

    MethodServer lookupMethod (int methodNumber) {
	switch (methodNumber) {
	    case GET:
	    case PEP_GET:
		return new GETServer();
	    case PUT:
	    case PEP_PUT:
		return new PUTServer();
	    default:
		errorContext.promoteError(REQUEST_NOT_IMPLEMENTED);
		return null;
	}
    }

    protected void prepStartLine () {
	if (instanceContext.hasRequiredExtensions())
	    makeRequestLine(getMethod1() | ITZA_PEP, url, "1.1");
    }

    void makeRequestLine (int methodNumber, URL url, String httpVersion) {
    	String requestURI = url == null ? URI : url.getFile();
	this.methodNumber = methodNumber;
	this.URI = URI;
	this.httpVersion = httpVersion;
	startLine = methods[methodNumber] + " " + requestURI + " " + "HTTP/" + httpVersion;
    }

    void setMethod (Method method) {
	this.methodNumber = arrayFind(methods, method.methodStr());
    }

    int getMethod1 () {return methodNumber;}
    String getVersion () {return httpVersion;}

}

