/* basicweb.Server.java
 * $Id, $Date eric Exp $
 * (c) COPYRIGHT MIT and INRIA, 1997.
 * Please first read the full copyright statement in file COPYRIGHT.html
 *
 * Caution: emits shower of sparks.
 */

package w3c.model.tools.basicweb;

import java.io.*;
import java.net.Socket;
import java.util.Properties;
import w3c.model.www.pep.PEPAgent;
import w3c.model.www.pep.PEPServer;
import w3c.model.www.pep.altlib.*;

public class Server extends BaseServer
{
    static final int DEFAULT_PORT = 8888;
    Properties properties;

    Server(int port, Properties properties, Informer informer) throws IOException {
    	super(port, informer);
	this.properties = properties;
	inform("server port: " + port);
	inform("server root: \"" + properties.getProperty(prop_SERVER_ROOT) + "/\"");
	super.serve();
    }

    Request makeRequest (Socket socket, InputStream in, OutputStream out, PEPAgent pepAgent, ErrorContext errorContext) {
	return new Request(socket, in, null, pepAgent, errorContext);
    }

    void prepPEP () throws HttpParserException, HTTPException {
	pepAgent = new PEPServer();
	/*- create and initialize optional <A NAME=makeAccessCounter>AccessCounter</A> */
	w3c.model.www.pep.extensions.accessCounter.Server accCounterServer = new w3c.model.www.pep.extensions.accessCounter.Server();
	accCounterServer.initialize(pepAgent, false, informer);
	pepAgent.addUrlExtension(accCounterServer, "/countable/*");
	pepAgent.addUrlExtension(accCounterServer, "/metered/*");

	/*- create and initialize required <A NAME=makeEscapeBody>EscapeBody</A> */
	w3c.model.www.pep.extensions.escapeBody.Server escapeServer = new w3c.model.www.pep.extensions.escapeBody.Server();
	escapeServer.initialize(pepAgent, true, informer);
	pepAgent.addUrlExtension(escapeServer, "/escaped/*");
	/*- <A NAME=proxyComp>compensate</A> for proxie's ignorance of accessCounter */
	if (false) {
	pepAgent.addUrlExtension(escapeServer, "/countable/escaped/*");
	pepAgent.addUrlExtension(escapeServer, "/metered/escaped/*");
	pepAgent.addUrlExtension(accCounterServer, "/countable/escaped/*");
	pepAgent.addUrlExtension(accCounterServer, "/metered/escaped/*");
	}

	/* emulate binary HTTP */
if (false) {	// awating multi-request persistent connections
	w3c.model.www.pep.extensions.escapeMessage.Server binaryServer = new w3c.model.www.pep.extensions.escapeMessage.Server();
	binaryServer.initialize(pepAgent, false, informer);
	/* would be addAlwaysExtension(binaryServer) but needs URL for C-PEP-INFO */
	pepAgent.addUrlExtension(binaryServer, "/*");
}
    }

    void preServe (Request request) {
	request.mapURI("/", properties.getProperty(prop_SERVER_ROOT) + "/");
    }

    public static void main (String args[]) throws IOException {
	int port = DEFAULT_PORT;
	Properties properties = System.getProperties();
	String root = properties.getProperty("user.dir");
	for (int i = 0 ; i < args.length ; i++) {
	    if ("-port".equals(args[i])) {
		try {
		    port = Integer.parseInt(args[++i]) ;
		} catch (NumberFormatException ex) {
		    System.out.println("invalid port number ["+args[i]+"]");
		    System.exit (1) ;
		}
	    }else if ("-root".equals(args[i])) {
		root = args[++i];
		System.out.println("new root:" + root);
	    }
	}
	properties.put(prop_SERVER_ROOT, root);
	new Server(port, properties, new Informer("<Server>", ": "));
    }
}

