package w3c.model.www.pep;

import w3c.model.www.pep.altlib.*;
import w3c.model.www.pep.bags.ExtDecl;

abstract public class PEPExtension {
    protected PEPAgent pepAgent;
    protected String URI;
    protected Informer informer = null;

/* 
<A NAME=constState>Message construction states</A> - the PEPExtension may be called 
at each of these states. It must decide when to do it's thing.
*/
    public final static int CONNECT = 1;
    public final static int STARTLINE = 2;
    public final static int NON_PEP_HEADERS = 3;
    public final static int HEADERS = 4;
    public final static int BODY = 5;

    protected void initialize(PEPAgent pepAgent, String URI, Informer informer) {
	this.pepAgent = pepAgent;
	this.URI = URI;
	this.informer = informer;
    }

    public String getURI () {
	return URI;
    }

    public boolean equals(String URI) {
	return URI.equals(this.URI);
    }

/*+
<P>
All construction arguments are passed in the initialize method. 
Class.newInstance can only call default constructors. </P>

<P>
<A HREF=PEPAgent#PEPAgent.load>PEPAgent.load</A> constructs and initializes 
the extension. The extension initializer below calls PEPExtension.initialize 
above. Extensions may also be initialized the 
<A HREF=../../tools.basicweb.Overview.html#agents>agent</A> directly.</P>
*/
    public PEPExtension() {
    }
    abstract public void initialize (PEPAgent pepAgent, boolean requiredExtension, Informer informer);
    abstract public boolean map (InstanceContext instanceContext, int when, PEPMessage message, String reason);
/*+
<A NAME=generating>Header generation</A> may occur at any of four 
<A HREF=constState>construction states</A>. The agent calls 
*/
    abstract public boolean generateHeaders(InstanceContext instanceContext, int when) throws HTTPException;
    abstract public boolean handleHeaders(InstanceContext instanceContext, int when) throws HTTPException;
/*+
<A NAME=instConst>Instance construction</A> occurs when a pep bag parser gets 
a call for an extension or when an extension is called upon to generate headers 
and it needs an instance.
*/
    abstract public PEPExtensionInstance makeInstance(String headerNames[], int headerNameCount, InstanceContext instanceContext);

    public void inform (String message) {informer.inform(message);}
    public void inform (String message, String text) {informer.inform(message, text);}

}

