package w3c.model.www.pep;

import java.net.*;
import java.util.Enumeration;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
/*+
The PEPMessage interface limits the <A HREF=../pep>PEP library's</A> view of 
the agent's <A HREF=../../tools/basicweb/Message.html>Message</A>. This is 
helpful in sussing out the minimum functionality across agents.
*/
public interface PEPMessage
{
/*+
<H2><A NAME=HeaderList>Header List</A></H2>
*/
    public static final int PEP = 0;
    public static final int C_PEP = 1;
    public static final int PEP_INFO = 2;
    public static final int C_PEP_INFO = 3;
    public static final int POLICY_DECLS = 2;

/*+
<H2><A NAME=MethodInterface>Method Interface</A></H2>
*/
    public void setHeaderValue(String name, String value);
    public void setHeaderValue(int name, String value);
    public String getHeaderValue(String name);
    public String getHeaderValue(int name);
    public Vector getMatchingHeaders(String name);	// for something like Content-*
    public Socket getSocket();
    public String getURI();
    public void mapURI (String from, String to);
    public String getMappedURI ();
    public String getMappedFile ();
    public InputStream getInputStream ();	//- <A HREF=../../tools/basicweb/Message.html#in>in</A>
    public void setInputStream (InputStream in);
    public OutputStream getOutputStream ();	//- <A HREF=../../tools/basicweb/Message.html#in>out</A>
    public void setOutputStream (OutputStream out);
}

