/* copyright 1997 World Wide Web Consortium
 * by Eric Prud'hommeaux
 * 
 * This class is dedicated to the memory
 * of the childhood I never had.
 */

package w3c.model.www.pep;

import java.net.*;
import java.util.*;

/* Party identified by host and port
 */
public class SiteParty implements Party {
    String host;
    int port;
    Vector extensionInstances = new Vector(1, 1);
    boolean mapped;

    public SiteParty(String host, int port) {
	this.host = host;
	this.port = port;
	this.mapped = true;
    }

    public void map () {this.mapped = true;}
    public void unmap () {this.mapped = false;}
    public boolean mapped () {return mapped;}

    public void addExtensionInstance (Object extensionInstance) {extensionInstances.addElement(extensionInstance);}
    public Enumeration extensionInstances () {return extensionInstances.elements();}

    public boolean equals (String host, int port) {
	if (host.equals(this.host) && port == this.port)
	    return true;
	return false;
    }

    public boolean matches (Party other) {
	if (!(other instanceof SiteParty))
	    return false;
	SiteParty otherSite = (SiteParty)other;
	if (otherSite.host.equals(host) && otherSite.port == port)
	    return true;
	return false;
    }

}

