// HttpBag.java
// $Id: HttpBag.java,v 1.2 1997/07/31 13:38:40 eric Exp $
// COPYRIGHT

package w3c.model.www.pep.altlib;

import java.util.*;

//import w3c.util.*;

/**
 * Internal representation of protocol headers conforming to the bag spec.
 * The <strong>bag</strong> specification is part of the Protocol Extension
 * Protocol defined by w3c, it can be found
 * <a href="http://www.w3.org/hypertext/WWW/TR/WD-http-pep.html>here</a>.
 */

public class HttpBag extends HttpRawBag {
    ArrayDictionary items	= null;

    protected void complete() {}

    protected HttpRawBag lookupSubBag(String name) throws HttpParserException {
	HttpBag bag = new HttpBag(true, name);
	items.put(bag.name, bag);
	return bag;
    }

    public void addElement(String name) throws HttpParserException {
	items.put(name, Boolean.TRUE);
    }

    protected final void updateByteValue() {
    HttpBuffer buf = new HttpBuffer();
    if ( isToplevel ) {
	// Dump this bag as a list of bags:
	Enumeration e = items.elements();
	boolean	 s = true;
	while ( e.hasMoreElements() ) {
	HttpBag bag = (HttpBag) e.nextElement();
	// Append separator if needed:
	if ( s )
	    s = false;
	else
	    buf.append((byte)',');
	// Dump the bag now:
	bag.appendValue(buf);
	}
    } else {
	buf.append((byte) '{');
	buf.append(name);
	buf.append((byte) ' ');
	// Append all items:
	Enumeration e = items.keys();
	boolean	 s = true;
	while (e.hasMoreElements()) {
	// Append separator after first item only:
	if ( s )
	    s = false;
	else
	    buf.append((byte) ' ');
	// Dump the item:
	String name  = (String) e.nextElement();
	Object value = items.get(name);
	if ( value instanceof Boolean ) {
	    buf.append(name);
	} else if ( value instanceof HttpBag ) {
	    ((HttpBag) value).appendValue(buf);
	} else {
	    String msg = "Invalid bag item value, key=\""+name+"\".";
	    throw new HttpInvalidValueException(msg);
	}
	}
	buf.append((byte) '}');
    }
    raw  = buf.getByteCopy();
    roff = 0;
    rlen = raw.length;
    }

    /**
     * Add a named bag into this bag.
     * @param bag The bag to add (in case item is a bag).
     */

/*	public void addBag (HttpBag subbag) {
    validate();
    items.put (subbag.getName(), subbag) ;
    }
*/
    /**
     * Does this bag have a named sub-bag of the given name ?
     * @param name The name of the sub-bag to be tested for.
     * @return <strong>true</strong> if this sub-bag exists.
     */

    public boolean hasBag (String name) {
    validate();
    Object item = items.get (name) ;
    if ( (item != null) && (item instanceof HttpBag) )
	return true ;
    return false ;
    }

    /**
     * Get a named sub-bag from this bag.
     * @param name The name of the sub-bag to get.
     * @return A bag instance, or <strong>null</strong> if none was found.
     */

    public HttpBag getBag (String name) {
    validate();
    if (hasBag (name))
	return (HttpBag) items.get (name) ;
    return null ;
    }

    /**
     * Add an item into this bag.
     * @param name The new item name.
     */

    public void addItem (String name) throws HttpParserException {
    validate();
    if (!verifyAtom(name))
	throw new HttpParserException("atom \""+name+"\" is illegal in this context.");
    items.put (name, Boolean.TRUE);
    }

    /**
     * Default atom verifyer allows all atoms.
     * @param name The atom to verify.
     */

    public boolean verifyAtom (String name) {
	return true;
    }

    /**
     * Add a sub-bag to this bag.
     * @param subbag The sub-bag to add.
     */

    public void addItem(HttpBag subbag) {
    validate();
    items.put(subbag.getName(), subbag);
    }

    /**
     * Does this bag contains the given item, being a bag or a simple word.
     * @param name The name of the item to test.
     * @return <strong>true</strong> if the bag contains the given item,
     *   <strong>false</strong> otherwise.
     */

    public boolean hasItem (String name) {
    validate();
    return items.get (name) != null ;
    }

    /**
     * Remove an item from that bag.
     * @param name The name of the item to remove.
     */

    public void removeItem(String name) {
    validate();
    items.remove(name);
    }

    /**
     * Get all named items from this bag.
     * This include both named sub-bags and items by their own.
     */

    public Enumeration keys () {
    validate();
    return items.keys() ;
    }

    /**
     * Is that a top level bag or not ?
     * @return A boolean, <strong>true</strong> if the bag was a toplevel
     * bag.
     */

    public boolean isToplevelBag() {
    return isToplevel;
    }

    public HttpBag() {
    super();
    this.items = new ArrayDictionary(5, 5);
    }

    HttpBag(String name) {
    super(name);
    this.items   = new ArrayDictionary(5, 5);
    }

    HttpBag(boolean isValid, String name) {
    super(isValid, name);
    this.items   = new ArrayDictionary(5, 5);
    }

}

