// HttpRawBag.java
// $Id: HttpRawBag.java,v 1.2 1997/07/31 13:38:43 eric Exp $
// COPYRIGHT

package w3c.model.www.pep.altlib;

import java.util.*;

/**
 * Internal representation of protocol headers conforming to the bag spec.
 * The <strong>bag</strong> specification is part of the Protocol Extension
 * Protocol defined by w3c, it can be found
 * <a href="http://www.w3.org/hypertext/WWW/TR/WD-http-pep.html>here</a>.
 */

abstract public class HttpRawBag extends BasicValue {
    boolean		isToplevel	= false;
    String		name		= null ;

    public Object getValue() {return this;}

    protected abstract HttpRawBag lookupSubBag (String name) throws HttpParserException ;
    protected abstract void complete () throws HttpParserException ;
    protected abstract void addElement (String atom) throws HttpParserException ;

    protected HttpRawBag parseBag(ParseState ps)
    throws HttpParserException
    {
    StringBuffer sb = new StringBuffer();
    int i  = ps.ioff;
    byte b = ps.raw[i];

    // skip spaces, check for opening bracket
//    while ((i < ps.bufend) && ((b = ps.raw[i]) <= 32)) !!!
    while ((i < ps.bufend) && ((b = ps.raw[i]) <= 32) && (b != ','))
	i++;
    if ( i >= ps.bufend )
	return null ;
    if (b != '{')
	error("Invalid Bag format (no {).") ;
    // skip spaces, bag list separators, get the bag name
//    for (++i; (i < ps.bufend) && ((b = ps.raw[i]) <= 32) ; i++) !!!
    for (++i; (i < ps.bufend) && ((b = ps.raw[i]) <= 32) && (b != ','); i++)
	;
    if ( i >= ps.bufend )
	error("Invalid Bag format (no name).") ;
//    while ((i < ps.bufend) && ((b = ps.raw[i]) > 32) && (b != '}') && (b != '{')) { !!!
    while ((i < ps.bufend) && ((b = ps.raw[i]) > 32) && (b != ',') && (b != '}') && (b != '{')) {
	sb.append ((char) b);
	i++;
    }
    HttpRawBag bag;
    if ((bag = lookupSubBag(sb.toString())) == null)
	throw new HttpParserException("no parser for \""+sb.toString()+"\".");
    bag.parseItems(sb, ps, i);
    bag.complete();
    return bag;
    }

    protected void parseItems(StringBuffer sb, ParseState ps, int i)
    throws HttpParserException
    {
    byte b;
    while (i < ps.bufend) {
	b = ps.raw[i];
//	if ( b <= 32 ) { !!!
	if ( b <= 32  || b == ',' ) {
	    i++;
	    continue ;
	} else if ( b == '}' ) {
	    ps.ooff = i+1;
	    return;
	} else if ( b == '{' ) {
	    ParseState inc = new ParseState(i, ps.bufend, ps.raw);
	    HttpRawBag subbag = parseBag (inc);
	    i = inc.ooff;
	} else if ( b == '\"') {
	    // get quoted string (FIXME, escape chars !)
	    sb.setLength(0);
	    i++;
	    sb.append ((char) '\"') ;
	    while ((i < ps.bufend) && ((b = ps.raw[i]) != '\"')) {
		sb.append ((char) b) ;
		i++;
	    }
	    sb.append ((char) '\"') ;
	    addElement(sb.toString());
	    i++;
	} else {
	    // get token (FIXME, see token spec and tspecials)
	    sb.setLength(0) ;
//	    while ((i < ps.bufend) && ((b = ps.raw[i]) > 32) && (b != '}')) { !!!
	    while ((i < ps.bufend) && ((b = ps.raw[i]) > 32) && (b != ',') && (b != '}')) {
		sb.append ((char) b) ;
		i++;
	    }
	    addElement(sb.toString());
	}
    }
    return;
    }

    public final void parse()
    throws HttpParserException
    {
    int i = roff;
    // Parses a list of bags:
    isToplevel  = true;
    HttpRawBag top = this;
    while ( i < rlen ) {
	switch(raw[i]) {
	case '{':
	    ParseState ps  = new ParseState(i, rlen, raw);
	    HttpRawBag	bag = parseBag(ps);
	    i = ps.ooff;
	    break;
	case ' ':
	case '\t':
	case ',':
	    i++;
	    break;
	default:
	    error("Unexpected separator \""+raw[i]+"\".");
	}
    }
    complete();
    }

    /**
     * Get this bag names
     * @return The name of this bag.
     */

    public String getName() {
    validate();
    return name ;
    }

    public HttpRawBag() {
    isValid	= false;
    }

    public HttpRawBag(String name) {
    this.isValid = true;
    this.name	= name ;
    }

    public HttpRawBag(boolean isValid, String name) {
    this.isValid = isValid;
    this.name	= name ;
    }

}

