/*+
The URL Class Loader is a simple network class loader taken from <U>JAVA
Network Programming</U> by <I>Eliotte Rusty Harold</I>. The only additions
are <TT>allowNetworkExtensions</TT>, which is checked before anything is
loaded from the network, and <TT>name = name.replace('.', '/')</TT>, which
changes from class paths to URL paths.
 */
package w3c.model.www.pep.altlib;

import java.util.Hashtable;
import java.net.*;
import java.io.*;

public class URLClassLoader extends ClassLoader {
    Hashtable cache;
    URL u;

    /* enable dynamic extensions */
    final static boolean allowNetworkExtensions=false;
    /* Set to false force extensions to be loaded from the network */
    final static boolean allowLocalExtensions=true;
    String pakage;	/* expected package of loaded classes */

    public URLClassLoader (URL u, String pakage) {
	this.u = u;
	this.pakage = pakage;
	cache = new Hashtable();
    }

    public synchronized Class loadClass (String name, boolean resolve) throws ClassNotFoundException {
	Class c = (Class) cache.get(name);

	if (c == null) {
	    if (allowLocalExtensions || name.indexOf(pakage) == -1)
	    try {
		c = findSystemClass(name);
	    } catch (ClassNotFoundException e) {
	    }
	}

	if (c == null) {
	    byte b[] = loadClassData(name);
	    c = defineClass(b, 0, b.length);
	    cache.put(name, c);
	}
	if (resolve)
	    resolveClass(c);
	return c;
    }

    private byte[] loadClassData (String name) throws ClassNotFoundException {
	byte[] b;
	InputStream theClass = null;
	int bfr = 128;

	if (!allowNetworkExtensions)
	    throw new ClassNotFoundException(name + " not authorized");
	try {
	    name = name.replace('.', '/');
	    URL classURL = new URL(u, name + ".class");
//	    System.err.println("loading class \""+classURL.toString()+"\"");
	    URLConnection uc = classURL.openConnection();
	    // on the advice of my attorney, uc.getInputStream before uc.getContentLength
	    try {
		theClass = uc.getInputStream();
	    } catch (NullPointerException e) {
		System.err.println(e);
		throw new ClassNotFoundException(name + " input stream problem");
	    }
	    int cl = uc.getContentLength();
	    b = new byte[cl == -1 ? bfr * 16 : cl];
	    int red = 0;
	    int offset = 0;
	    while (red >= 0) {
		red = theClass.read(b, offset, bfr);
		if (red == -1)
		    break;
		offset += red;
		if (cl == -1 && offset == b.length) { // grow array
		    byte temp[] = new byte[offset * 2];
		    System.arraycopy(b, 0, temp, 0, offset);
		    b = temp;
		} else if (offset > b.length) // class longer than advertised
		    throw new ClassNotFoundException(name + " error reading data into array");
	    }
	    if (offset < b.length) { // shrink
		byte temp[] = new byte[offset];
		System.arraycopy(b, 0, temp, 0, offset);
		b = temp;
	    }
	} catch (Exception e) {
	    throw new ClassNotFoundException(name + " " + e);
	}
	finally {
	    try {
		if (theClass != null)
		    theClass.close();
	    }catch (IOException e) {
	    }
	}
	return b;
    }

}

