/* copyright 1997 World Wide Web Consortium
 * by Eric Prud'hommeaux
 *
 * For my housemate Kelly, who has never
 * had buggy code dedicated to her before.
 */

package w3c.model.www.pep.altlib;

import java.util.*;

public class WildCardEnumeration implements Enumeration {
    WildCardVector wildCards;
    String text;
    boolean wild;
    int index;
    String reason = null;

    WildCardEnumeration (WildCardVector v, String text, boolean wild) {
	wildCards = v;
	this.text = text;
	this.wild = wild;
	index = wildCards.matchingElementLocation(text, wild, true);
    }

    public boolean hasMoreElements() {
	if (index == -1 || index >= wildCards.size())
	    return false;
	if (wildCards.matchElement(index, text, wild) != 0)
	    return false;
	return true;
    }

    public Object nextElement() {
	synchronized (wildCards) {
	    if (index < wildCards.size() && wildCards.matchElement(index, text, wild) == 0) {
		WildCardElement element = (WildCardElement)wildCards.elements.elementAt(index);
		reason = element.text;
		index = wildCards.matchingElementLocation(text, wild, true, index + 1);
//		++index;
		return element.object;
	    }
	}
	throw new NoSuchElementException("WildCardEnumeration");
    }

    public String reason () {
	return reason;
    }

}
