/* copyright 1997 World Wide Web Consortium
 * by Eric Prud'hommeaux
 *
 * For Katy Guimond, who's patience and understanding
 * made it possible for me to finish writing this class.
 */

package w3c.model.www.pep.altlib;

import java.util.*;

public class WildCardVector {
    char wildChar;
    Vector elements;

    public WildCardVector (int initialCapacity, char wildChar) {
	elements = new Vector(initialCapacity);
	this.wildChar = wildChar;
    }

    public final synchronized String toString() {
	int max = elements.size() - 1;
	StringBuffer buf = new StringBuffer();
	Enumeration e = elements.elements();
	buf.append("[");

	for (int i = 0 ; i <= max ; i++) {
	    WildCardElement element = (WildCardElement)e.nextElement();
	    String s = element.toString();
	    buf.append(s);
	    if (i < max) {
	    buf.append(", ");
	    }
	}
	buf.append("]");
	return buf.toString();
    }

    public int matchElement (int i, String text, boolean wild) {
	WildCardElement element = (WildCardElement)elements.elementAt(i);
	return element.compareTo(text, wild);
    }

    public int matchingElementLocation (String text, boolean wild, boolean first) {
	return matchingElementLocation (text, wild, first, 0);
    }

    public int matchingElementLocation (String text, boolean wild, boolean first, int start) {
	int i;
	int last = -1;
	boolean lastIsWild = false;
	boolean perfectMatch = false;
	int lastLength = 0;
	if (start >elements.size())
	    return -1;
	for (i = start; i < elements.size(); i++) {
	    WildCardElement element = (WildCardElement)elements.elementAt(i);
	    int ret = element.compareTo(text, wild);
	    int thisLength = element.text.length();
	    /* look for best match
	     *     most characters
	     *     least wild
	     */
	    if (ret == 0) {
		if (first)
		    return i;
		if (lastIsWild || thisLength > lastLength) {
		    last = i;
		    lastIsWild = element.wild;
		    lastLength = thisLength;
		    perfectMatch = true;
		}
	    } else if (ret > 0)
		return last;
	    else if (!perfectMatch) /* Don't overwrite good matches. If (first) */
		last = i;	    /*        we would have returned it anyway. */
	}
	return last;
    }

    /* image sorting URLs with '*' as the wildChar:
    wildcards come at the end of the region they match:
    http://www.w3.org/pub/WWW/Propagation
    http://www.w3.org/pub/WWW/Protocol*
    http://www.w3.org/pub/WWW/Protocols
    http://www.w3.org/pub/WWW/Protocols*     <- imagine adding this element
    http://www.w3.org/pub/WWW/Protocols/PEP
    http://www.w3.org/pub/WWW/Protocols/PEP*
    http://www.w3.org/pub/WWW/Provider
    */
    public Object sortIn (String text, boolean wild, Object object) {
	WildCardElement newElement = new WildCardElement(text, wild, object);

	/* start at http://www.w3.org/pub/WWW/Protocols */
	for (int i = matchingElementLocation(text, false, false); i < elements.size(); i++) {
	    if (i == -1) {
		elements.insertElementAt(newElement, 0);
		return null;
	    }
	    WildCardElement element = (WildCardElement)elements.elementAt(i);
	    if (element.equals(text, wild)) { /* replace identical elements */
		elements.setElementAt(newElement, i);
		return element.object;
	    }
	    int ret = element.compareTo(text, false);
	    /* tames go before wilds */
	    if (ret > 0 || (ret == 0 && !wild)) {
		elements.insertElementAt(newElement, i);
		return null;
	    }
	}
	/* stick it on the end */
	elements.addElement(newElement);
	return null;
    }

    public Object sortIn (String text, Object object) {
	int l = text.length();
	if (text.charAt(l - 1) == wildChar)
	    return sortIn(text.substring(0, l-1), true, object);
	else
	    return sortIn(text, false, object);
    }

    public Object lookUp (String text) {
	int i = matchingElementLocation(text, false, false);
	if (i > elements.size())
	    return null;
	WildCardElement element = (WildCardElement)elements.elementAt(i);
	return element.compareTo(text, false) == 0 ? element.object : null;
    }

    public int size () {return elements.size();}

    public WildCardEnumeration allMatching (String text, boolean wild) {
	return new WildCardEnumeration (this, text, wild);
    }

    public Enumeration elements () {
	return elements.elements();
    }

/*	-	 Keep for debugging		- */
    public static void main (String args[]) {
	WildCardVector toy = new WildCardVector(5, '*');
	
	toy.sortIn("http://www.w3.org/pub/WWW/Protocols/PEP*", new Integer(6));
	toy.sortIn("http://www.w3.org/pub/WWW/Protocols/PEP", new Integer(5));
	toy.sortIn("http://www.w3.org/pub/WWW/Protocols", new Integer(3));
	toy.sortIn("http://www.w3.org/pub/WWW/Protocol*", new Integer(2));
	toy.sortIn("http://www.w3.org/pub/WWW/Provider", new Integer(7));
	toy.sortIn("http://www.w3.org/pub/WWW/Protocols*", new Integer(4));
	toy.sortIn("http://www.w3.org/pub/WWW/Propagation", new Integer(1));
	System.out.println(toy.toString());
	System.out.println(toy.lookUp("http://www.w3.org/pub/WWW/Protocols/PEP"));
	System.out.println(toy.lookUp("http://www.w3.org/pub/WWW/Protocols/PEPa"));
	System.out.println(toy.lookUp("http://www.w3.org/pub/WWW/Protocol"));
	System.out.println(toy.lookUp("http://www.w3.org/pub/WWW/Protocola"));
	System.out.println(toy.lookUp("http://www.w3.org/pub/WWW/Protocols"));
	System.out.println(toy.lookUp("http://www.w3.org/pub/WWW/Protocolsa"));

	System.out.println("matching \"http://www.w3.org/pub/WWW/Protocols\".");
	Enumeration en = toy.allMatching("http://www.w3.org/pub/WWW/Protocols", false);
	while (en.hasMoreElements())
	    System.out.println(((Integer)en.nextElement()).toString());
    }


}

