// MapBag.java
// $Id: ForBag.java,v 1.2 1997/07/31 13:38:50 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class ForBag extends PEPBag {
    Vector uriWildcards;

    protected void complete () throws HttpParserException {
	if (uriWildcards.size() < 1)
	    throw new HttpParserException("ForBag needs at least one element");
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append("{for");
	Enumeration key = uriWildcards.elements();
	for (int i = 0; key.hasMoreElements(); i++) {
	    String temp = (String) key.nextElement();
	    if (i == 0)
		buf.append(" ");
	    else
		buf.append(",");
	    buf.append(temp);
	}
	buf.append((char) '}');
    }

    public Vector getHeaderWildcards () {return uriWildcards;}

    protected HttpRawBag lookupSubBag (String name) throws BagNotAllowedException {
	throw new BagNotAllowedException(name, "ForBag");
    }

    public void addElement (String name) throws NotAllowedException {
	if (name.startsWith("\""))
	    name = name.substring(1, name.length() - 1);
	if (name.equals("*")) {
	    int i = uriWildcards.size() - 1;
	    String path = (String)uriWildcards.elementAt(i);
	    uriWildcards.setElementAt(path.concat("*"), i);
	} else
	    uriWildcards.addElement(name);
    }

    ForBag(String name, InstanceContext instanceContext) throws HttpParserException {
	super(name, instanceContext);
	uriWildcards = new Vector(0, 1);
    }

    public ForBag (InstanceContext instanceContext, String uriWildcards[], int uriWildcardCount) {
	super("map", instanceContext);
	this.uriWildcards = new Vector(uriWildcardCount, 1);
	for (int i = 0; i < uriWildcardCount; i++)
	    this.uriWildcards.addElement(uriWildcards[i]);
    }

    public ForBag (InstanceContext instanceContext, Enumeration e, PEPExtension extension) {
	super("", instanceContext);
	uriWildcards = new Vector(0, 1);
	for (int i = 0; e.hasMoreElements();) {
	    WildCardElement element = (WildCardElement)e.nextElement();
	    if (element.sameObject(extension)) {
		String str = element.toString();
		uriWildcards.addElement(str);
		i++;
	    }
	}
    }

}

