// MapBag.java
// $Id: MapBag.java,v 1.2 1997/07/31 13:38:51 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class MapBag extends PEPBag {
    String URI = null;
    Vector headerWildcards;

    protected void complete () throws HttpParserException {
	if (URI == null)
	    throw new MissingElementException("URI", "MapBag");
	if (headerWildcards.size() < 1)
	    throw new HttpParserException("MapBag needs at least one element");
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append("{map \"");
	buf.append(URI);
	buf.append((byte)'\"');
	Enumeration key = headerWildcards.elements();
	for (int i = 0; key.hasMoreElements(); i++) {
	    String temp = (String) key.nextElement();
	    if (i == 0)
		buf.append(" ");
	    else
		buf.append(",");
	    buf.append(temp);
	}
	buf.append((char) '}');
    }

    public String getURI () {return URI;}
    public Vector getHeaderWildcards () {return headerWildcards;}

    protected HttpRawBag lookupSubBag (String name) throws BagNotAllowedException {
	throw new BagNotAllowedException(name, "MapBag");
    }

    public void addElement (String name) throws NotAllowedException {
	if (URI == null) {
	    if (name.indexOf('"') != 0 || name.lastIndexOf('"') != name.length()-1)
		throw new NotAllowedException("unquoted URI", name, "MapBag");
	    URI = name.substring(1, name.length()-1);
	    return;
	}
	headerWildcards.addElement(name);
    }

    MapBag(String name, InstanceContext instanceContext) throws HttpParserException {
	super(name, instanceContext);
	headerWildcards = new Vector(0, 1);
    }

    public MapBag (InstanceContext instanceContext, String URI, String headerNames[], int headerNameCount) {
	super("map", instanceContext);
	this.URI = URI;
	headerWildcards = new Vector(headerNameCount, 1);
	for (int i = 0; i < headerNameCount; i++)
	    headerWildcards.addElement(headerNames[i]);
    }

    public MapBag (InstanceContext instanceContext, String URI, String headerNames[], boolean wilds[], int headerNameCount) {
	super("map", instanceContext);
	this.URI = URI;
	headerWildcards = new Vector(headerNameCount, 1);
	for (int i = 0; i < headerNameCount; i++) {
	    String add = headerNames[i];
	    if (wilds[i])
		add = add.concat("*");
	    headerWildcards.addElement(add);
	}
    }

}

