// UnmapBag.java
// $Id: UnmapBag.java,v 1.2 1997/07/31 13:38:57 eric Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.model.www.pep.bags;

import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.altlib.*;

public class UnmapBag extends PEPBag {
    Vector headerWildcards = new Vector(0, 1);

    protected void complete () throws HttpParserException {
	if (headerWildcards.size() < 1)
	    throw new HttpParserException("UnmapBag needs at least one element");
    }

    protected final void bufferize (HttpBuffer buf) {
	buf.append("{unmap");
	Enumeration key = headerWildcards.elements();
	while (key.hasMoreElements()) {
	    String temp = (String) key.nextElement();
	    buf.append(" " + temp);
	}
	buf.append((char) '}');
    }

    protected HttpRawBag lookupSubBag (String name) throws BagNotAllowedException {
	throw new BagNotAllowedException(name, "UnmapBag");
    }

    public void addElement (String name) throws NotAllowedException {
	headerWildcards.addElement(name);
    }

    UnmapBag(String name, InstanceContext instanceContext) throws HttpParserException {super(name, instanceContext);}

}

