package w3c.model.www.pep.extensions.accessCounter;

import java.net.*;
import java.util.*;
import w3c.model.www.pep.*;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.altlib.*;

abstract public class Common extends PEPExtension {
    final static String prefHeaderName = "AccessCounter-";
/*+
The <A NAME=extensionPort>port</A> for the extensions server is not the same 
as for the <A HREF=../../../../tools/basicweb/Server.html:DEFAULT_PORT>Server 
default port</A>. If it were, the 
<A HREF=../../../../tools/basicweb/Server.html:singleThreaded>single threaded 
</A> server could not repsond to the request for the extension classes as it 
would still be replying to the request that forced the extension to load.
*/
    protected final static String absoluteURI = "http://localhost:8887/src/classes/accessCounter";
    boolean requiredExtension;
    Vector sites;

    abstract int getPort(Socket socket);
/*+
Constructed and Initialized by:
<UL><LI><A HREF=../../../../tools/basicweb/Server.html#makeAccessCounter>basicweb.Server</A>
    <LI><A HREF=../../../../tools/basicweb/Client.html#makeAccessCounter>basicweb.Client</A></UL>
*/
    public Common () {}

    public void initialize (PEPAgent pepAgent, boolean requiredExtension, Informer informer) {
	super.initialize(pepAgent, absoluteURI, informer);
	this.requiredExtension = requiredExtension;
	sites = new Vector(1, 1);
    }

    SiteParty lookupSite (Socket socket) {
	String host = socket.getInetAddress().getHostAddress();
	int port = getPort(socket); // client and server both key on server port
	Enumeration key = sites.elements();
	while (key.hasMoreElements()) {
	    SiteParty site = (SiteParty) key.nextElement();
	    if (site.equals(host, port))
		return site;
	}
	return null;
    }

/*+
<DT><A NAME=makeInstance>makeInstance</A>: <DD>create an instance for a newly mapped header.<P>
<A HREF=../../../../tools/basicweb/Message.html#Message.read>Message.read</A> -> 
<A HREF=../../PEPAgent.html#PEPAgent.handleHeaders>PEPAgent.handleHeaders</A> -> 
<A HREF=../../altlib/HttpRawBag.html#HttpRawBag.parse>parse</A> -> 
<A HREF=../../bags/ExtDecl.html#ExtDecl.complete>complete</A> -> 
<A HREF=../../PEPAgent.html#PEPAgent.makeInstance>PEPAgent.makeInstance</A> -> makeInstance
*/
    public PEPExtensionInstance makeInstance (String headerNames[], int headerNameCount, InstanceContext instanceContext) {
	SiteParty site;
	Instance ret;
	Socket socket = instanceContext.getMessage().getSocket();
	if ((site = lookupSite(socket)) != null) {
	    Enumeration instances = site.extensionInstances();
	    /* site exists so there should be exactly one instance */
	    ret = (Instance)instances.nextElement();
	    ret.setHeaderName(headerNames[0]);
	    site.map();
	    return ret; 
	}
	String host = socket.getInetAddress().getHostAddress();
	int port = getPort(socket); /* client and server both key on server port */
	site = new SiteParty(host, port);
	site.addExtensionInstance(ret = new Instance(headerNames[0], informer)); /* this extension only uses one headerName */
	sites.addElement(site);
	return ret;
    }

    abstract public boolean outCheck (InstanceContext instanceContext, SiteParty site);
    abstract public boolean inCheck (InstanceContext instanceContext, SiteParty site);

    public boolean map (InstanceContext instanceContext, int when, PEPMessage message, String reason) {
	message.mapURI(reason, "/");
	return true;
    }

/*+
<DT><A NAME=generateHeaders>generateHeaders</A>: <DD>output any headers for this extension.<P>
<A HREF=../../../../tools/basicweb/Message.html#Message.writeHeaders>Message.writeHeaders</A> -> 
<A HREF=../../PEPAgent.html#PEPAgent.generateHeaders>PEPAgent.generateHeaders</A> -> accessCounter.generateHeaders
*/
    public boolean generateHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	PEPMessage message = instanceContext.getMessage();
	if (when == PEPExtension.CONNECT && requiredExtension)
	    instanceContext.setRequiredExtensions();
	if (when != PEPExtension.CONNECT)
	    return false;
	Instance inst;
	SiteParty site = lookupSite(message.getSocket());
	if (!outCheck(instanceContext, site))
	    return true;
	if (site == null) {
//			makeBag(instanceContext);
	    if ((site = lookupSite(message.getSocket())) == null)
		throw new HTTPException ("internal error: can't find newly created AccessCounterBag");
	}
//		Enumeration key = site.extensionInstances();
	Enumeration key = instanceContext.getExtensionInstances(this);
	while (key.hasMoreElements()) {
	    inst = (Instance)key.nextElement();
	    message.setHeaderValue(inst.getHeaderName(), String.valueOf(inst.getCount()));
	}
        site.unmap();
        return true;
    }

/*+
<DT><A NAME=handleHeaders>handleHeaders</A>: <DD>read any headers mapping or alread mapped for this extension.<P>
<A HREF=../../../../tools/basicweb/Message.html#Message.read>Message.read</A> -> 
<A HREF=../../PEPAgent.html#PEPAgent.handleHeaders>PEPAgent.handleHeaders</A> -> accessCounter.handleHeaders
*/
    public boolean handleHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when != PEPExtension.HEADERS)
	    return false;
	/* look for instance - assume many SiteParties with same header */
	PEPMessage message = instanceContext.getMessage();
	SiteParty site = lookupSite(message.getSocket());	//- <A NAME=getSiteInfo>get site info</A>
	inCheck(instanceContext, site);
//	if (!inCheck(instanceContext, site))
//	    return true;
//		Enumeration key = site.extensionInstances();
	Enumeration key = instanceContext.getExtensionInstances(this);
	while (key.hasMoreElements()) {
	    Instance inst = (Instance)key.nextElement();
	    String otherSide = message.getHeaderValue(inst.getHeaderName());
	    if (otherSide == null)
		inform("Other side has didn't pass a reference count");
	    else
		inform("Other side has referenced us "+otherSide+" times");
	}
	return true;
    }

}

