package w3c.model.www.pep.extensions.escape;

import w3c.model.www.pep.PEPExtensionInstance;
import w3c.model.www.pep.altlib.Informer;
import java.io.InputStream;
import java.io.OutputStream;

public class EscapeInstance extends PEPExtensionInstance {
    char escapeChar;

    public EscapeInstance (String headerName, Informer informer) {
    	super(headerName, informer);
    }

    protected EscapeInstance (String headerName, char escapeChar, Informer informer) {
	super(headerName, informer);
	this.escapeChar = escapeChar;
    }

    protected void setEscapeChar (char escapeChar) {
	this.escapeChar = escapeChar;
    }

    protected char getEscapeChar () {
	return escapeChar;
    }

    protected boolean isEscape (char comp) {return comp == escapeChar;}

    public InputStream makeInputStream (InputStream in) {
	return new EscapedInputStream(in, this);
    }

    public OutputStream makeOutputStream (OutputStream out) {
	return new EscapedOutputStream(out, this);
    }

    public void inform (String message) {informer.inform(message);}
    public void inform (String message, String text) {informer.inform(message, text);}

}

