package w3c.model.www.pep.extensions.escapeMessage;

import w3c.model.www.pep.*;
import w3c.model.www.pep.bags.*;
import w3c.model.www.pep.extensions.escape.EscapeInstance;
import w3c.model.www.pep.altlib.HTTPException;

public class Client extends Common {
    public void makeBag (InstanceContext instanceContext) {
	String name = instanceContext.getPepAgent().nextFreeName(prefHeaderName, this, false);
	String headerNames[] = new String[1];
	headerNames[0] = name;
	ExtDecl extDecl = new ExtDecl(instanceContext,
	    new MapBag(instanceContext, URI, headerNames, 1),
	    new StrengthBag(instanceContext, requiredExtension));

	instanceContext.addExtDecl(extDecl, PEPMessage.C_PEP);
    }

    public boolean generateHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	PEPMessage message = instanceContext.getMessage();
	if (when != PEPExtension.CONNECT)
	    return false;
	makeBag(instanceContext);
	if (requiredExtension)
	    instanceContext.setRequiredExtensions();
	return true;
    }

    public boolean handleHeaders (InstanceContext instanceContext, int when) throws HTTPException {
	if (when != PEPExtension.CONNECT)
	    return false;
	PEPMessage message = instanceContext.getMessage();
	EscapeInstance inst = new EscapeInstance(null, informer);
	message.setInputStream(inst.makeInputStream(message.getInputStream()));
	return true;
    }

}

