package w3c.model.www.pep.extensions.remoteControl;

import w3c.model.www.pep.*;
import java.util.Vector;

public class Server extends Common {
    public PEPExtensionInstance makeInstance (String headerNames[], int headerNameCount, InstanceContext instanceContext) {
	return new ServerInstance(headerNames[0], informer);
    }

    void generateHeader (PEPExtensionInstance inst, InstanceContext instanceContext, PEPMessage message) {
    	ServerInstance serverInstance = (ServerInstance)inst;
    	serverInstance.generateHeaders(message);
    }

    void handleHeader (PEPExtensionInstance inst, PEPMessage message) {
    	ServerInstance serverInstance = (ServerInstance)inst;
    	String headerNameWildcard = serverInstance.getHeaderName();
	Vector headers = message.getMatchingHeaders(headerNameWildcard);
	for (int i = 0; i < headers.size(); i++) {
	    String header = (String)headers.elementAt(i);
	    String command = message.getHeaderValue(header);
	    inform("Other side wants us to \""+command+"\"");
	    serverInstance.execute(header, command);
	}
    }

}

